<?php
session_start();
include('connection.php');
if (!isset($_SESSION['admin_login'])) {
    echo "<script>window.location='login.php';</script>";
    exit;
}
$admin_username = $_SESSION['admin_login'];
$_SESSION['user_type'] = 'Teacher';

$subjects = [
    'Mathematics' => 'mathematics',
    'English' => 'english',
    'Kiswahili' => 'kiswahili',
    'Physics' => 'physics',
    'Chemistry' => 'chemistry',
    'Biology' => 'biology',
    'Geography' => 'geography',
    'History' => 'history',
    'Civics' => 'civics',
    'French' => 'french',
    'Literature' => 'literature'
];

function calculateGradeAndPoint($score)
{
    if ($score >= 75) return [1, 'A'];
    if ($score >= 65) return [2, 'B'];
    if ($score >= 45) return [3, 'C'];
    if ($score >= 30) return [4, 'D'];
    return [5, 'F'];
}

function calculateDivision($total_points)
{
    if ($total_points >= 7 && $total_points <= 17) return "I";
    if ($total_points >= 18 && $total_points <= 21) return "II";
    if ($total_points >= 22 && $total_points <= 25) return "III";
    if ($total_points >= 26 && $total_points <= 33) return "IV";
    return "0";
}

$results = [];
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $class = $_POST['class'];
    $exam_type = $_POST['exam_type'];
    $year = $_POST['year'];

    $sql = "SELECT s.registration_number, s.full_name, s.gender";

    foreach ($subjects as $subject_name => $table_name) {
        $sql .= ", 
                  (SELECT score FROM $table_name t 
                  WHERE t.registration_number = s.registration_number 
                  AND t.class = '$class' 
                  AND t.exam_type = '$exam_type' 
                  AND t.year = '$year') AS $subject_name";
    }

    $sql .= " FROM students s WHERE s.class = '$class'";
    $stmt = $con->prepare($sql);
    $stmt->execute();
    $result = $stmt->get_result();

    while ($row = $result->fetch_assoc()) {
        $points = [];
        $subject_scores = [];
        $subject_grades = [];
        $total_score = 0;
        $subject_count = 0;

        foreach ($subjects as $subject_name => $table_name) {
            $score = $row[$subject_name];
            if (!is_null($score)) {
                list($point, $grade) = calculateGradeAndPoint($score);
                $points[] = $point;
                $subject_scores[$subject_name] = $score;
                $subject_grades[$subject_name] = $grade;
                $total_score += $score;
                $subject_count++;
            } else {
                $subject_scores[$subject_name] = 'N/A';
                $subject_grades[$subject_name] = 'N/A';
            }
        }

        sort($points);
        $total_points = array_sum(array_slice($points, 0, 7));
        $division = calculateDivision($total_points);
        $average_score = $subject_count > 0 ? round($total_score / $subject_count, 2) : 0;
        list($overall_point, $overall_grade) = calculateGradeAndPoint($average_score);

        $results[] = [
            'registration_number' => $row['registration_number'],
            'full_name' => $row['full_name'],
            'gender' => $row['gender'],
            'subject_scores' => $subject_scores,
            'subject_grades' => $subject_grades,
            'total_score' => $total_score,
            'total_points' => $total_points,
            'division' => $division,
            'average_score' => $average_score,
            'overall_grade' => $overall_grade
        ];
    }

    // Rank students by total score
    usort($results, function ($a, $b) {
        return $b['total_score'] <=> $a['total_score'];
    });

    // Add positions
    $rank = 1;
    foreach ($results as &$result) {
        $result['position'] = $rank++;
    }
    unset($result);
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Teacher | View Results</title>
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            padding-top: 80px;
        }
        .navbar-brand {
            font-weight: bold;
        }
        .form-group {
            margin-bottom: 1.5rem;
        }
        table th, table td {
            text-align: center;
            vertical-align: middle;
        }
        .table-responsive {
            overflow-x: auto;
        }
        .btn-custom {
            background-color: #007bff;
            color: white;
        }
        .btn-custom:hover {
            background-color: #0056b3;
        }
        .results-container {
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            border-radius: 8px;
            padding: 20px;
            background-color: #f8f9fa;
        }
    </style>
</head>
<body>

<nav class="navbar navbar-expand-lg navbar-light bg-light fixed-top">
    <a class="navbar-brand" href="#">Admin Dashboard</a>
    <div class="collapse navbar-collapse">
        <span class="navbar-text">Welcome, <?php echo htmlspecialchars($admin_username); ?>!</span>
    </div>
</nav>

<div class="container mt-5 results-container">
    <h2 class="text-center mb-4">View School Results</h2>

    <form method="POST">
        <div class="row">
            <div class="col-md-4">
                <div class="form-group">
                    <label for="class">Class</label>
                    <select name="class" id="class" class="form-control" required>
                        <option value="">Select Class</option>
                        <option value="Form One">Form One</option>
                        <option value="Form Two">Form Two</option>
                        <option value="Form Three">Form Three</option>
                        <option value="Form Four">Form Four</option>
                    </select>
                </div>
            </div>

            <div class="col-md-4">
                <div class="form-group">
                    <label for="exam_type">Exam Type</label>
                    <select name="exam_type" id="exam_type" class="form-control" required>
                        <option value="">Select Exam Type</option>
                <option value="Midterm_1_Examination">Midterm 1 Examination</option>
                <option value="Terminal_Examination">Terminal Examination</option>
                <option value="Midterm_2_Examination">Midterm 2 Examination</option>
                <option value="Annual_Examination">Annual Examination</option>
                <option value="Mock_Examination">Mock Examination</option>
                    </select>
                </div>
            </div>

            <div class="col-md-4">
                <div class="form-group">
                    <label for="year">Year</label>
                    <select name="year" id="year" class="form-control" required>
                        <?php
                        $currentYear = date('Y');
                        for ($year = 2010; $year <= $currentYear; $year++) {
                            echo "<option value='$year'>$year</option>";
                        }
                        ?>
                    </select>
                </div>
            </div>
        </div>

        <button type="submit" class="btn btn-custom btn-block">Fetch Results</button>
    </form>

    <?php if (!empty($results)): ?>
        <div class="table-responsive mt-4">
            <table class="table table-bordered table-striped table-hover">
                <thead>
                    <tr>
                        <th>Position</th>
                        <th>Reg Number</th>
                        <th>Full Name</th>
                        <th>Gender</th>
                        <th>Scores</th>
                        <th>Points</th>
                        <th>Division</th>
                        <th>Average</th>
                        <th>Grade</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($results as $result): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($result['position']); ?></td>
                            <td><?php echo htmlspecialchars($result['registration_number']); ?></td>
                            <td><?php echo htmlspecialchars($result['full_name']); ?></td>
                            <td><?php echo htmlspecialchars($result['gender']); ?></td>
                            <td><?php echo htmlspecialchars($result['total_score']); ?></td>
                            <td><?php echo htmlspecialchars($result['total_points']); ?></td>
                            <td><?php echo htmlspecialchars($result['division']); ?></td>
                            <td><?php echo htmlspecialchars($result['average_score']); ?></td>
                            <td><?php echo htmlspecialchars($result['overall_grade']); ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    <?php endif; ?>
</div>

<script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.3/dist/umd/popper.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html>
